﻿using System;
using Smartling.Connector.Model;
using Smartling.Connector.Security;
using Smartling.Connector.Translation;

namespace Smartling.Connector.sitecore_modules.Shell.Smartling.Connector
{
  using System.Web;

  /// <summary>
  /// Summary description for DownloadTranslation
  /// </summary>
  public class DownloadTranslation : IHttpHandler
  {
    public void ProcessRequest(HttpContext context)
    {
      if (SecurityManager.AccessAllowed())
      {
        var query = HttpContext.Current.Request.QueryString;
        var items = query["items"];
        var downloadService = new DownloadService(ModuleConstants.CallingContext.Dashboard);
        var queue = new TranslationQueue();

        ProcessDownload(items, queue, downloadService);
      }
    }

    public static void ProcessDownload(string items, TranslationQueue queue, DownloadService downloadService)
    {
      if (string.IsNullOrEmpty(items))
      {
        return;
      }

      foreach (var item in items.Split(new[] {','}, StringSplitOptions.RemoveEmptyEntries))
      {
        int itemId;
        if (int.TryParse(item, out itemId))
        {
          var queuedItem = queue.Get(itemId);
          downloadService.DownloadItem(queuedItem, false);
        }
      }
    }

    public bool IsReusable
    {
      get
      {
        return false;
      }
    }
  }
}